/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import vectorwing.farmersdelight.registry.ModBlocks;

public class MushroomColonyBlock
extends BushBlock
implements IGrowable {
    public static final int GROWING_LIGHT_LEVEL = 12;
    public static final int PLACING_LIGHT_LEVEL = 13;
    public final Supplier<Item> mushroomType;
    public static final IntegerProperty COLONY_AGE = BlockStateProperties.field_208168_U;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};

    public MushroomColonyBlock(AbstractBlock.Properties properties, Supplier<Item> mushroomType) {
        super(properties);
        this.mushroomType = mushroomType;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)COLONY_AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return COLONY_AGE;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200015_d(worldIn, pos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_235714_a_((ITag)BlockTags.field_242171_aD)) {
            return true;
        }
        return worldIn.func_226659_b_(pos, 0) < 13 && blockstate.canSustainPlant((IBlockReader)worldIn, blockpos, Direction.UP, (IPlantable)this);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        int age = (Integer)state.func_177229_b((Property)COLONY_AGE);
        ItemStack heldItem = player.func_184586_b(handIn);
        if (age > 0 && heldItem.func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS)) {
            MushroomColonyBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.func_185473_a((IBlockReader)worldIn, pos, state));
            worldIn.func_184133_a(null, pos, SoundEvents.field_187784_dt, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)COLONY_AGE, (Comparable)Integer.valueOf(age - 1)), 2);
            if (!worldIn.field_72995_K) {
                heldItem.func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)COLONY_AGE) < 3;
    }

    public int getMaxAge() {
        return 3;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        int age = (Integer)state.func_177229_b((Property)COLONY_AGE);
        BlockState groundState = worldIn.func_180495_p(pos.func_177977_b());
        if (age < this.getMaxAge() && groundState.func_177230_c() == ModBlocks.RICH_SOIL.get() && worldIn.func_226659_b_(pos.func_177984_a(), 0) <= 12 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)COLONY_AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this.mushroomType.get());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{COLONY_AGE});
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int age = Math.min(3, (Integer)state.func_177229_b((Property)COLONY_AGE) + 1);
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)COLONY_AGE, (Comparable)Integer.valueOf(age)), 2);
    }
}

